package at.nullpointer.guiprototype;

import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;

import at.nullpointer.guiprototype.menu.PrototypeMenuBar;
import at.nullpointer.guiprototype.standby.StandbyJLabel;

public class Prototype {
	
	static int state = 0;
	
	public static JFrame createGUI() {
		// Ein Fenster erzeugen
		JFrame frame = new JFrame("StoreCardReader");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setBounds(50, 50, 640, 480);
		//frame.pack();
		frame.setVisible(true);
		
		return frame;
	}
	
	public static JFrame showGUI(JFrame frame){
		// Das Fenster auf sichtbar setzen
		//frame.pack();
		frame.setVisible(true);
		
		return frame;
	}
	
	/**
	 * Ein Simpler Mechanismus entscheidet welche Oberflche der Prototyp
	 * darstellen soll. Hier wurde bewusst auf die Behandlung von Exceptions 
	 * und hnliches zwecks Vereinfachung verzichtet.
	 * 
	 * @param args 1... Wartescreen, 2... Datenanzeige, 3... Dateneingabe
	 */
	public static void main(String[] args) {
		
		if(args != null && args.length != 1) {
			System.err.println("Error selecting JFrame");
			System.exit(0);
		}
		
		state = Integer.parseInt(args[0]);
		
		// Zwecks Threadsicherheit wird die Methode die die
		// GUI anzeigt vom event-dispatching Thread gestartet
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JFrame gui = addMenu(createGUI());
				switch(state){
				case 1: // WarteScreen
					fillFrameWithPendingContent(gui);
					break;
				case 2: // Daten anzeigen
					//TODO
					break;
				case 3: // Daten eingeben
					//TODO
					break;
				default:
				
				}
				showGUI(gui);
			}

		});

	}

  public JFrame addMenu(JFrame frame) {
				JMenuBar menubar = new PrototypeMenuBar();
				frame.setJMenuBar(menubar);
				return frame;
			}
			
			public JFrame fillFrameWithPendingContent(JFrame frame){
				JLabel standbyJLabel = new StandbyJLabel();
				frame.getContentPane().add(standbyJLabel, BorderLayout.CENTER);
				return frame;
			}

}
