package at.nullpointer.learningswing.mock;

/**
 * Mockobjekt als Simulation eines Kundenkartenlesesystem
 * 
 * @author fake
 * 
 */
public class MockCardReader {

	private final int aktiveKdnr = 12345;
	private final int gesperrteKdnr = 54321;
	private final int neueKdnr = 66666;

	/**
	 * Liefert eine aktive Kundennummer zurck Public Methode um JUnitTestflle
	 * zu untersttzen
	 * 
	 * @return int
	 */
	public int getAktiveKdnr() {
		return aktiveKdnr;
	}

	/**
	 * Liefert eine gesperrte Kundennummer zurck Public Methode um
	 * JUnitTestflle zu untersttzen
	 * 
	 * @return int
	 */
	public int getGesperrteKdnr() {
		return gesperrteKdnr;
	}

	/**
	 * Liefert eine neue Kundennummer zurck Public Methode um JUnitTestflle zu
	 * untersttzen
	 * 
	 * @return int
	 */
	public int getNeueKdnr() {
		return neueKdnr;
	}

	/**
	 * Liefert eine Kundennummer zurck
	 * 
	 * @return
	 */
	public int getKdnr() {
		int choose = (int) (System.currentTimeMillis() % 3);
		switch (choose) {
		case 0:
			return aktiveKdnr;
		case 1:
			return gesperrteKdnr;
		case 2:
			return neueKdnr;
		default:
			return aktiveKdnr;
		}
	}

}
