package at.nullpointer.learningswing.mock;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Simulation der Firmenkundendatenbank
 * 
 * @author fake
 * 
 */
public class MockCompanySoftware {

	private Map<Integer, Kundendaten> kundendaten = new HashMap<Integer, Kundendaten>();

	/**
	 * Erzeugt und befllt initial die Datenbank
	 */
	public MockCompanySoftware() {
		Kundendaten kd1 = new Kundendaten(12345, "Max", "Mustermann",
				"Mustermannstrae 3#1111 MusterWien", 1305840610, true,
				new Date(2010, 10, 10), "Filiale 03");
		Kundendaten kd2 = new Kundendaten(54321, "Maxime", "Musterfrau",
				"Wo anders 4#1111 MusterWien", 1231543656, false, new Date(
						2010, 9, 10), "Filiale 03");

		kundendaten.put(Integer.valueOf(kd1.getKdnr()), kd1);
		kundendaten.put(Integer.valueOf(kd2.getKdnr()), kd2);
	}

	/**
	 * Man kann die Kundendaten eines Kunden ber die Kundennummer abfragen
	 * 
	 * @param kundennummer
	 * @return Kundendaten wenn vorhanden, null wenn nicht vorhanden
	 */
	public Kundendaten getKundendaten(int kundennummer) {
		return kundendaten.get(Integer.valueOf(kundennummer));
	}
	
	public String setKundendaten(Kundendaten kdata){
		return "Daten gesandt";
	}
}
