package at.nullpointer.guiprototype;

import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

import at.nullpointer.guiprototype.menu.PrototypeMenuBar;
import at.nullpointer.guiprototype.showdata.ShowDataJPanel;
import at.nullpointer.guiprototype.standby.FooterJLabel;
import at.nullpointer.guiprototype.standby.StandbyJLabel;

public class Prototype {
	
	static int state = 0;
	
	public static JFrame createGUI() {
		// Ein Fenster erzeugen
		JFrame frame = new JFrame("StoreCardReader");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setBounds(50, 50, 640, 480);
		//frame.pack();
		frame.setVisible(true);
		
		frame.add(new FooterJLabel(), BorderLayout.PAGE_END);
		
		return frame;
	}
	
	public static JFrame showGUI(JFrame frame){
		// Das Fenster auf sichtbar setzen
		//frame.pack();
		frame.setVisible(true);
		
		return frame;
	}
	
	/**
	 * Ein Simpler Mechanismus entscheidet welche Oberflche der Prototyp
	 * darstellen soll. Hier wurde bewusst auf die Behandlung von Exceptions 
	 * und hnliches zwecks Vereinfachung verzichtet.
	 * 
	 * @param args 1... Wartescreen, 2... Datenanzeige, 3... Dateneingabe
	 */
	public static void main(String[] args) {
		
		if(args != null && args.length != 1) {
			System.err.println("Error selecting JFrame");
			System.exit(0);
		}
		
		state = Integer.parseInt(args[0]);
		
		// Zwecks Threadsicherheit wird die Methode die die
		// GUI anzeigt vom event-dispatching Thread gestartet
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JFrame gui = addMenu(createGUI());
				switch(state){
				case 1: // WarteScreen
					fillFrameWithPendingContent(gui);
					break;
				case 2: // Daten anzeigen
					fillFrameWithDataContent(gui);
					break;
				case 3: // Daten eingeben
					//TODO
					break;
				default:
				
				}
				showGUI(gui);
			}

		});

	}
	
	public JFrame fillFrameWithDataContent(JFrame frame) {
				// wir erzeugen uns die Datenansicht
				JPanel showData = new ShowDataJPanel();
				// und fgen sie dem BorderLayout in der Mitt hinzu
				frame.getContentPane().add(showData, BorderLayout.CENTER);
				// Zur optischen Verschnerung erzeugen wir in den noch nicht
				// belegten Feldern des Borderlayouts noch Rot grundierte Bereiche
                JPanel placeholder_top = new JPanel();
                placeholder_top.setBackground(Color.RED);
                JPanel placeholder_right = new JPanel();
                placeholder_right.setBackground(Color.RED);
                JPanel placeholder_left = new JPanel();
                placeholder_left.setBackground(Color.RED);
				frame.getContentPane().add(placeholder_top, BorderLayout.PAGE_START);
				frame.getContentPane().add(placeholder_right, BorderLayout.LINE_START);
				frame.getContentPane().add(placeholder_left, BorderLayout.LINE_END);
				
				return frame;
			}

			public JFrame addMenu(JFrame frame) {
				JMenuBar menubar = new PrototypeMenuBar();
				frame.setJMenuBar(menubar);
				return frame;
			}
			
			public JFrame fillFrameWithPendingContent(JFrame frame){
				JLabel standbyJLabel = new StandbyJLabel();
				frame.getContentPane().add(standbyJLabel, BorderLayout.CENTER);
				return frame;
			}

}
