package at.nullpointer.guiprototype.menu;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class PrototypeMenuBar extends JMenuBar {
	JMenu file, help;
	JMenuItem close;

	public PrototypeMenuBar() {
		
		super();
		// Das Men mit dem namen Datei erstellen
		file = new JMenu("Datei");
		// Den Buchstaben D unterstreichen
		file.setMnemonic(KeyEvent.VK_D);
		// Eine Beschreibung anfgen
		file.getAccessibleContext().setAccessibleDescription(
				"Hier knnen Sie das Programm beenden");
		// Der JMenuBar hinzufgen, sonst wird es nicht angezeigt
		this.add(file);

		// Ein Menitem erzeugen
		close = new JMenuItem("Beenden", KeyEvent.VK_B);
		// Darstellung des Tastenkrzels
		close.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_B,
				ActionEvent.ALT_MASK));
		close.getAccessibleContext().setAccessibleDescription(
				"Beendet das Programm.");
		file.add(close);

		// Das Help Men erstellen
		help = new JMenu("?");
		help.setMnemonic(KeyEvent.VK_HELP);
		help.getAccessibleContext().setAccessibleDescription(
				"Nicht implementiert!");
		this.add(help);

	}
}
