package at.nullpointer.guiprototype.showdata;

import java.awt.Color;
import java.awt.Dimension;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShowDataJPanel extends JPanel {

	Dimension lineSmall = new Dimension(0, 5);
	Dimension lineBig = new Dimension(0, 50);
	Dimension rowSmall = new Dimension(5, 0);

	public ShowDataJPanel() {

		this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		this.setBackground(Color.RED);
		this.setOpaque(true);

		// Status Zeile
		// Ein Container fr die Zeile
		JPanel statePanel = new JPanel();
		// Mit dem BoxLayout.LINE_AXIS um die Elemente in der Zeile auszurichten
		statePanel.setLayout(new BoxLayout(statePanel, BoxLayout.LINE_AXIS));
		// Das erklrende Label
		JLabel stateLabel = new ShowDataJLabel("Status");
		// Das daten-haltende Label
		JLabel stateContent = new ShowDataJLabel("aktiv");
		// Wir wollen dass die Labels an der rechten Seite kleben
		statePanel.add(Box.createHorizontalGlue());
		statePanel.add(stateLabel);
		// 5 Pixel Abstand zwischen den Label
		statePanel.add(Box.createRigidArea(rowSmall));
		statePanel.add(stateContent);
		this.add(statePanel);
		this.add(Box.createRigidArea(lineBig));

		// kdnr
		JPanel kdnrPanel = new JPanel();
		kdnrPanel.setLayout(new BoxLayout(kdnrPanel, BoxLayout.LINE_AXIS));
		JLabel kdnrLabel = new ShowDataJLabel("Kundennummer");
		JLabel kdnrContent = new ShowDataJLabel("0123456");
		kdnrPanel.add(kdnrLabel);
		kdnrPanel.add(Box.createHorizontalGlue());
		kdnrPanel.add(kdnrContent);
		this.add(kdnrPanel);
		this.add(Box.createRigidArea(lineSmall));

		// Vorname
		JPanel prenamePanell = new JPanel();
		prenamePanell.setLayout(new BoxLayout(prenamePanell,
				BoxLayout.LINE_AXIS));
		JLabel prenameLabel = new ShowDataJLabel("Vorname");
		JLabel prenameContent = new ShowDataJLabel("Max");
		prenamePanell.add(prenameLabel);
		prenamePanell.add(Box.createHorizontalGlue());
		prenamePanell.add(prenameContent);
		this.add(prenamePanell);
		this.add(Box.createRigidArea(lineSmall));

		// Nachname
		JPanel namePanel = new JPanel();
		namePanel.setLayout(new BoxLayout(namePanel, BoxLayout.LINE_AXIS));
		JLabel nameLabel = new ShowDataJLabel("Nachname");
		JLabel nameContent = new ShowDataJLabel("Mustermann");
		namePanel.add(nameLabel);
		namePanel.add(Box.createHorizontalGlue());
		namePanel.add(nameContent);
		this.add(namePanel);
		this.add(Box.createRigidArea(lineSmall));

		// Adresse
		JPanel adressPanel = new JPanel();
		adressPanel.setLayout(new BoxLayout(adressPanel, BoxLayout.LINE_AXIS));
		JLabel adressLabel = new ShowDataJLabel("Adresse");
		JLabel adressContent = new ShowDataJLabel(
				"Mustermannstrae 5 11111 Musterhausen");
		adressPanel.add(adressLabel);
		adressPanel.add(Box.createHorizontalGlue());
		adressPanel.add(adressContent);
		this.add(adressPanel);
		this.add(Box.createRigidArea(lineSmall));

		// Telefonnummer
		JPanel telnrPanel = new JPanel();
		telnrPanel.setLayout(new BoxLayout(telnrPanel, BoxLayout.LINE_AXIS));
		JLabel telnrLabel = new ShowDataJLabel("Telefon");
		JLabel telnrContent = new ShowDataJLabel("012345634535");
		telnrPanel.add(telnrLabel);
		telnrPanel.add(Box.createHorizontalGlue());
		telnrPanel.add(telnrContent);
		this.add(telnrPanel);
		this.add(Box.createVerticalGlue());

		// Zuletzt aktiv
		JPanel lastPanel = new JPanel();
		lastPanel.setLayout(new BoxLayout(lastPanel, BoxLayout.LINE_AXIS));
		JLabel lastLabel = new ShowDataJLabel("Zuletzt aktiv:");
		JLabel lastContent = new ShowDataJLabel("10.10.2010 10:10");
		lastPanel.add(lastLabel);
		lastPanel.add(Box.createHorizontalGlue());
		lastPanel.add(lastContent);
		this.add(lastPanel);
		this.add(Box.createRigidArea(lineSmall));

		// in Filiale
		JPanel storePanel = new JPanel();
		storePanel.setLayout(new BoxLayout(storePanel, BoxLayout.LINE_AXIS));
		JLabel storeLabel = new ShowDataJLabel("in Filiale");
		JLabel storeContent = new ShowDataJLabel("Musterhausen 3");
		storePanel.add(storeLabel);
		storePanel.add(Box.createHorizontalGlue());
		storePanel.add(storeContent);
		this.add(storePanel);
		this.add(Box.createRigidArea(lineSmall));

	}

}
